DROP TABLE IF EXISTS `site_plugin_blog_authors`;
CREATE TABLE `site_plugin_blog_authors` (
  `author_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `author_details` int(1) NOT NULL,
  `author_name` varchar(255) NOT NULL,
  `author_url` varchar(255) NOT NULL,
  `author_image` int(1) NOT NULL,
  `author_user` int(11) NOT NULL,
  `author_topics` int(11) NOT NULL,
  `author_social_1_icon` varchar(50) NOT NULL,
  `author_social_1_link` varchar(255) NOT NULL,
  `author_social_2_icon` varchar(50) NOT NULL,
  `author_social_2_link` varchar(255) NOT NULL,
  `author_social_3_icon` varchar(50) NOT NULL,
  `author_social_3_link` varchar(255) NOT NULL,
  `author_social_4_icon` varchar(50) NOT NULL,
  `author_social_4_link` varchar(255) NOT NULL,
  `author_social_5_icon` varchar(50) NOT NULL,
  `author_social_5_link` varchar(255) NOT NULL,
  `author_css` varchar(255) NOT NULL,
  `author_css_list` varchar(255) NOT NULL,
  `author_css_details` varchar(255) NOT NULL,
  PRIMARY KEY (`author_id`),
  KEY `author_id` (`author_id`,`module_id`),
  KEY `author_url` (`author_url`),
  KEY `author_user` (`author_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_blog_authors_lang`;
CREATE TABLE `site_plugin_blog_authors_lang` (
  `author_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `author_brief` text NOT NULL,
  `author_bio` longtext NOT NULL,
  `author_image_alt` varchar(255) NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  KEY `author_id` (`author_id`,`lang_id`,`module_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_blog_labels`;
CREATE TABLE `site_plugin_blog_labels` (
  `label_id` int(11) NOT NULL AUTO_INCREMENT,
  `label_order` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `label_status` int(1) NOT NULL,
  `label_all` int(1) NOT NULL,
  `label_protect` int(1) NOT NULL,
  `label_perm` text NOT NULL,
  `label_perm_member` text NOT NULL,
  `label_parent` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`label_id`),
  KEY `label_id` (`label_id`,`module_id`,`label_status`,`label_parent`),
  KEY `label_order` (`label_order`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_blog_labels_lang`;
CREATE TABLE `site_plugin_blog_labels_lang` (
  `label_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `label_title` varchar(255) NOT NULL,
  `label_page_title` varchar(255) NOT NULL,
  `label_desc` text NOT NULL,
  `label_url` varchar(255) NOT NULL,
  `label_items` int(11) NOT NULL,
  `label_perms` text NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  KEY `label_id` (`label_id`,`module_id`,`lang_id`),
  KEY `label_id_2` (`label_id`,`module_id`,`lang_id`,`label_url`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_blog_topics`;
CREATE TABLE `site_plugin_blog_topics` (
  `item_id` int(11) NOT NULL AUTO_INCREMENT,
  `module_id` int(11) NOT NULL,
  `item_order` int(11) NOT NULL,
  `item_author` int(11) NOT NULL DEFAULT 0,
  `item_author_box` int(1) NOT NULL DEFAULT 0,
  `item_status` int(1) NOT NULL DEFAULT 0,
  `item_feat` int(1) NOT NULL DEFAULT 0,
  `item_date` int(11) NOT NULL,
  `item_date_year` int(4) NOT NULL,
  `item_date_month` int(2) NOT NULL,
  `item_date_day` int(2) NOT NULL,
  `item_labels` text NOT NULL,
  `item_stats_comments` int(11) NOT NULL,
  `item_stats_views` int(11) NOT NULL,
  `item_comments` int(11) NOT NULL,
  `item_comments_new` int(1) NOT NULL,
  `item_image` int(11) NOT NULL,
  `item_protect` int(1) NOT NULL,
  `item_tn` int(11) NOT NULL,
  `item_image_type` int(2) NOT NULL,
  `item_image_list` int(1) NOT NULL,
  `item_image_details` int(1) NOT NULL,
  `item_youtube` varchar(50) NOT NULL,
  `item_vimeo` varchar(50) NOT NULL,
  `item_css_list` varchar(255) NOT NULL,
  `item_css_details` varchar(255) NOT NULL,
  PRIMARY KEY (`item_id`),
  KEY `item_id` (`item_id`,`module_id`,`item_order`,`item_author`,`item_date`,`item_protect`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_plugin_blog_topics_lang`;
CREATE TABLE `site_plugin_blog_topics_lang` (
  `item_id` int(11) NOT NULL,
  `module_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `item_title` varchar(255) NOT NULL,
  `item_url` varchar(255) NOT NULL,
  `item_brief` text NOT NULL,
  `item_body` longtext NOT NULL,
  `item_tags` varchar(255) NOT NULL,
  `seo_title` text NOT NULL,
  `seo_desc` text NOT NULL,
  `seo_meta` text NOT NULL,
  `seo_conv_head` text NOT NULL,
  `seo_conv_body` text NOT NULL,
  KEY `item_id` (`item_id`),
  KEY `module_id` (`module_id`),
  KEY `lang_id` (`lang_id`),
  KEY `item_url` (`item_url`),
  FULLTEXT KEY `item_title` (`item_title`),
  FULLTEXT KEY `item_body` (`item_body`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

